import allure
from pages.clickevents_page import ClickEventsPage
from tests.base_test import BaseTest


@allure.epic("События")
@allure.feature("Animal Buttons")
class TestClickEventsPage(BaseTest):
    def setup_method(self):
        self.click_events_page = ClickEventsPage(self.driver)
        self.click_events_page.open()

    @allure.title("Тест кнопки Cat")
    def test_cat_button(self):
        try:
            with allure.step("Кликнуть на кнопку Cat"):
                self.click_events_page.click_cat_button()

            with allure.step("Проверить текст результата"):
                result = self.click_events_page.get_result_text()
                assert result == "Meow!", f"Ожидался 'Meow!', получен '{result}'"
        except Exception as e:
            self.allure_screenshot()
            raise e


    @allure.title("Тест кнопки Dog")
    def test_dog_button(self):
        try:
            with allure.step("Кликнуть на кнопку Dog"):
                self.click_events_page.click_dog_button()

            with allure.step("Проверить текст результата"):
                result = self.click_events_page.get_result_text()
                assert result == "Woof!", f"Ожидался 'Woof!', получен '{result}'"
        except Exception as e:
            self.allure_screenshot()
            raise e

    @allure.title("Тест кнопки Pig")
    def test_pig_button(self):
        try:
            with allure.step("Кликнуть на кнопку Pig"):
                self.click_events_page.click_pig_button()

            with allure.step("Проверить текст результата"):
                result = self.click_events_page.get_result_text()
                assert result == "Oink!", f"Ожидался 'Oink!', получен '{result}'"
        except Exception as e:
            self.allure_screenshot()
            raise e

    @allure.title("Тест кнопки Cow")
    def test_cow_button(self):
        try:
            with allure.step("Кликнуть на кнопку Cow"):
                self.click_events_page.click_cow_button()

            with allure.step("Проверить текст результата"):
                result = self.click_events_page.get_result_text()
                assert result == "Moo!", f"Ожидался 'Moo!', получен '{result}'"
        except Exception as e:
            self.allure_screenshot()
            raise e